package gov.va.vamf.scheduling.varutility.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "validationError")
public class ValidationError implements Serializable {
    private static final long serialVersionUID = 8972887733136598649L;

    @XmlElement
    private String errorField;
    @XmlElement
    private String errorMessage;

    public ValidationError() {
    }

    public ValidationError(String errorField, String errorMessage) {
        this.errorField = errorField;
        this.errorMessage = errorMessage;
    }

    public ValidationError(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorField = "General";
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorField() {
        return errorField;
    }

    public void setErrorField(String errorField) {
        this.errorField = errorField;
    }

}
